/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.KnownPolynomial;

public class UserFunction
implements FunctionEditor.FObject,
KnownFunction,
MultiVarFunction,
Cloneable {
    protected static final String[] dummyVars = new String[]{"'", "@", "`", "~", "#"};
    protected String name;
    protected String[] paramNames = new String[0];
    protected double[] paramValues = new double[0];
    protected String[] paramDescriptions = new String[0];
    protected String[] functionNames = new String[0];
    protected ParsedMultiVarFunction myFunction = null;
    protected String[] vars = new String[]{"x"};
    protected UserFunction[] references = new UserFunction[0];
    protected boolean nameEditable = true;
    protected String description;
    protected KnownPolynomial polynomial;
    private double myval = Double.NaN;
    private String dummyInputString = "0";
    private String clearExpr;
    private String clearInput;
    private String paddedExpr;
    private String paddedInput;
    private boolean isNull;
    private double[] temp;

    public UserFunction(String name) {
        this.setName(name);
        try {
            this.myFunction = new ParsedMultiVarFunction("0", new String[0], false);
            this.functionNames = this.myFunction.getFunctionNames();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    public UserFunction(String name, String[] funcVars, String description) {
        this(name);
        this.setNameEditable(false);
        this.setExpression("0", funcVars);
        this.setDescription(description);
    }

    public UserFunction(KnownPolynomial poly) {
        this(poly.getName());
        this.polynomial = poly;
        this.setName(poly.getName());
        this.setDescription(poly.getDescription());
        String[] params = new String[poly.getParameterCount()];
        double[] paramValues = new double[poly.getParameterCount()];
        String[] desc = new String[poly.getParameterCount()];
        int i = 0;
        while (i < params.length) {
            params[i] = poly.getParameterName(i);
            paramValues[i] = poly.getParameterValue(i);
            desc[i] = poly.getParameterDescription(i);
            ++i;
        }
        this.setParameters(params, paramValues, desc);
        this.setExpression(poly.getExpression("x"), new String[]{"x"});
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (!this.isNameEditable()) {
            return;
        }
        this.name = name;
    }

    public boolean isNameEditable() {
        return this.nameEditable;
    }

    public void setNameEditable(boolean editable) {
        this.nameEditable = editable;
    }

    public String getIndependentVariable() {
        return this.vars[0];
    }

    public String[] getIndependentVariables() {
        return this.vars;
    }

    public String getInputString() {
        return this.clearInput;
    }

    public String getExpression() {
        return this.clearExpr == null ? this.generateExpressionForVars() : this.clearExpr;
    }

    @Override
    public String getExpression(String indepVarName) {
        return this.getExpression(new String[]{indepVarName});
    }

    public String getExpression(String[] varNames) {
        this.vars = varNames;
        return this.generateExpressionForVars();
    }

    public String getFullExpression(String[] varNames) {
        this.getExpression(varNames);
        String s = this.paddedExpr;
        int i = 0;
        int n = this.references.length;
        while (i < n) {
            UserFunction f = this.references[i];
            s = UserFunction.replaceAllWords(s, f.getName(), "(" + f.getFullExpression(varNames) + ")");
            ++i;
        }
        return s.replaceAll(" ", "");
    }

    public boolean setExpression(String exp, String[] vars) {
        this.paddedInput = exp;
        this.clearInput = exp = exp.replaceAll(" ", "");
        this.isNull = exp.equals("0");
        String[] names = this.setVariables(vars);
        boolean hasDummy = false;
        if (!this.isNull) {
            exp = UserFunction.padNames(exp);
            int i = 0;
            while (i < vars.length) {
                hasDummy = hasDummy || exp.indexOf(dummyVars[i]) >= 0;
                exp = exp.replaceAll(" " + vars[i] + " ", " " + dummyVars[i] + " ");
                ++i;
            }
        }
        this.dummyInputString = exp;
        try {
            this.myFunction = new ParsedMultiVarFunction(exp, names, false);
            if (this.isNull || exp.indexOf("=") < 0) {
                if (hasDummy) {
                    this.generateExpressionForVars();
                } else {
                    this.clearExpr = this.clearInput;
                }
                return true;
            }
        }
        catch (ParserException ex) {
            try {
                this.myFunction = new ParsedMultiVarFunction("0", names, false);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
            this.clearExpr = "0";
        }
        return false;
    }

    private String[] setVariables(String[] vars) {
        this.vars = vars;
        String[] names = new String[vars.length + this.paramNames.length + this.references.length];
        int i = 0;
        while (i < vars.length) {
            names[i] = dummyVars[i];
            ++i;
        }
        i = 0;
        while (i < this.paramNames.length) {
            names[i + vars.length] = this.paramNames[i];
            ++i;
        }
        i = 0;
        while (i < this.references.length) {
            names[i + vars.length + this.paramNames.length] = this.references[i].getName();
            ++i;
        }
        return names;
    }

    private String generateExpressionForVars() {
        String exp = this.dummyInputString;
        int i = 0;
        while (i < this.vars.length) {
            exp = exp.replaceAll(dummyVars[i], this.vars[i]);
            ++i;
        }
        this.paddedExpr = exp;
        this.clearInput = this.clearExpr = exp.replaceAll(" ", "");
        return this.clearExpr;
    }

    @Override
    public int getParameterCount() {
        return this.paramNames.length;
    }

    @Override
    public String getParameterName(int i) {
        return this.paramNames[i];
    }

    @Override
    public double getParameterValue(int i) {
        return this.paramValues[i];
    }

    @Override
    public void setParameterValue(int i, double value) {
        this.paramValues[i] = value;
    }

    public void setParameters(String[] names, double[] values) {
        this.paramNames = names;
        this.paramValues = values;
    }

    @Override
    public void setParameters(String[] names, double[] values, String[] descriptions) {
        this.paramNames = names;
        this.paramValues = values;
        if (descriptions != null) {
            this.paramDescriptions = descriptions;
        }
        this.temp = new double[values.length];
    }

    public void updateReferenceParameters() {
        int i = 0;
        int n = this.references.length;
        while (i < n) {
            UserFunction next = this.references[i];
            next.setParameters(this.paramNames, this.paramValues, this.paramDescriptions);
            next.updateReferenceParameters();
            ++i;
        }
    }

    public void setReferences(UserFunction[] functions) {
        this.references = functions;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public String getParameterDescription(int i) {
        if (i >= this.paramDescriptions.length) {
            return null;
        }
        return this.paramDescriptions[i];
    }

    public String[] getFunctionNames() {
        return this.functionNames;
    }

    @Override
    public double evaluate(double x) {
        if (this.myFunction == null) {
            return Double.NaN;
        }
        this.ensureBufferLength(1);
        this.temp[0] = x;
        System.arraycopy(this.paramValues, 0, this.temp, 1, this.paramValues.length);
        int pt = 1 + this.paramValues.length;
        int n = this.references.length;
        int i = 0;
        while (i < n) {
            this.temp[pt++] = this.references[i++].evaluate(x);
        }
        return this.myFunction.evaluate(this.temp);
    }

    @Override
    public double evaluate(double[] x) {
        if (this.myFunction == null) {
            return Double.NaN;
        }
        this.ensureBufferLength(x.length);
        System.arraycopy(x, 0, this.temp, 0, x.length);
        System.arraycopy(this.paramValues, 0, this.temp, x.length, this.paramValues.length);
        int pt = x.length + this.paramValues.length;
        int n = this.references.length;
        int i = 0;
        while (i < n) {
            this.temp[pt++] = this.references[i++].evaluate(x);
        }
        return this.myFunction.evaluate(this.temp);
    }

    public double evaluateMyVal(double[] x) {
        if (this.myFunction == null) {
            return Double.NaN;
        }
        if (this.isNull) {
            return 0.0;
        }
        if (Double.isNaN(this.myval)) {
            this.ensureBufferLength(x.length);
            System.arraycopy(x, 0, this.temp, 0, x.length);
            System.arraycopy(this.paramValues, 0, this.temp, x.length, this.paramValues.length);
            int pt = x.length + this.paramValues.length;
            int n = this.references.length;
            int i = 0;
            while (i < n) {
                this.temp[pt++] = this.references[i++].evaluateMyVal(x);
            }
            this.myval = this.myFunction.evaluate(this.temp);
        }
        return this.myval;
    }

    public void clear() {
        this.myval = Double.NaN;
        int i = this.references.length;
        while (--i >= 0) {
            this.references[i].clear();
        }
    }

    private void ensureBufferLength(int xLen) {
        int n = xLen + this.paramValues.length + this.references.length;
        if (this.temp == null || this.temp.length < n) {
            this.temp = new double[n];
        }
    }

    public boolean evaluatedToNaN() {
        return !this.isNull && this.myFunction != null && this.myFunction.evaluatedToNaN();
    }

    @Override
    public UserFunction clone() {
        UserFunction f = new UserFunction(this.name);
        f.setDescription(this.description);
        f.setNameEditable(this.nameEditable);
        f.setParameters(this.paramNames, this.paramValues, this.paramDescriptions);
        UserFunction[] refs = new UserFunction[this.references.length];
        int i = 0;
        while (i < refs.length) {
            refs[i] = this.references[i].clone();
            ++i;
        }
        f.setReferences(refs);
        f.setExpression(this.dummyInputString, this.vars);
        f.polynomial = this.polynomial == null ? null : this.polynomial.clone();
        return f;
    }

    @Override
    public boolean equals(Object f) {
        if (!(f instanceof UserFunction)) {
            return false;
        }
        UserFunction uf = (UserFunction)f;
        if (!this.getName().equals(uf.getName())) {
            return false;
        }
        if (!this.getInputString().equals(uf.getInputString())) {
            return false;
        }
        int n = this.getParameterCount();
        if (n != uf.getParameterCount()) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (!this.getParameterName(i).equals(uf.getParameterName(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean updatePolynomial() {
        if (this.polynomial == null) {
            return false;
        }
        this.polynomial.setName(this.getName());
        this.polynomial.setDescription(this.getDescription());
        this.polynomial.setParameters(this.paramNames, this.paramValues, this.paramDescriptions);
        return true;
    }

    protected String replaceParameterNameInExpression(String oldName, String newName) {
        String exp = UserFunction.replaceAllWords(this.paddedInput, oldName, newName);
        return exp != null && this.setExpression(exp, this.getIndependentVariables()) ? exp : null;
    }

    public static String padNames(String exp) {
        return exp.replaceAll("([A-Za-z_\u03b8\u03c9]\\w*)", " $1 ").replaceAll("([0123456789\\.]) ([eE])", "$1$2").replaceAll("([eE]) ([-])", "$1$2");
    }

    private static String replaceAllWords(String paddedExp, String key, String rep) {
        return paddedExp.replaceAll(" " + key + " ", " " + rep + " ");
    }

    public static boolean containsWord(String paddedExp, String key) {
        return paddedExp.indexOf(" " + key + " ") >= 0;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public String toString() {
        return "[UserFunction " + this.name + " = " + this.myFunction.toString() + "]";
    }

    public boolean isValid() {
        return this.clearExpr == this.clearInput;
    }

    @Override
    public UserFunction newUserFunction(String var) {
        return this.clone();
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            UserFunction f = (UserFunction)obj;
            control.setValue("name", f.getName());
            control.setValue("description", f.getDescription());
            control.setValue("name_editable", f.isNameEditable());
            control.setValue("parameter_names", f.paramNames);
            control.setValue("parameter_values", f.paramValues);
            control.setValue("parameter_descriptions", f.paramDescriptions);
            control.setValue("variables", f.getIndependentVariables());
            control.setValue("expression", f.getInputString());
            if (f.polynomial != null) {
                control.setValue("polynomial", f.polynomial.getCoefficients());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            String name = control.getString("name");
            return new UserFunction(name);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            String[] vars;
            String[] names;
            UserFunction f = (UserFunction)obj;
            f.setName(control.getString("name"));
            f.setDescription(control.getString("description"));
            if (control.getPropertyNamesRaw().contains("name_editable")) {
                f.setNameEditable(control.getBoolean("name_editable"));
            }
            if ((names = (String[])control.getObject("parameter_names")) != null) {
                double[] values = (double[])control.getObject("parameter_values");
                String[] desc = (String[])control.getObject("parameter_descriptions");
                f.setParameters(names, values, desc);
            }
            if ((vars = (String[])control.getObject("variables")) == null) {
                String var = control.getString("variable");
                vars = new String[]{var};
            }
            f.setExpression(control.getString("expression"), vars);
            double[] coeff = (double[])control.getObject("polynomial");
            if (coeff != null) {
                f.polynomial = new KnownPolynomial(coeff);
            }
            return obj;
        }
    }
}

