/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.BitSet;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.UserFunction;

public class UserFunctionEditor
extends FunctionEditor {
    private UserFunction[] mainFunctions = new UserFunction[0];
    private String[] defaultVariableNames = new String[]{"x"};
    protected boolean parametersValid = true;

    @Override
    protected void setTitles() {
    }

    public UserFunction[] getMainFunctions() {
        return this.mainFunctions;
    }

    public void setMainFunctions(UserFunction[] functions) {
        UserFunction[] f = this.getMainFunctions();
        int i = 0;
        int n = f.length;
        while (i < n) {
            this.objects.remove(f[i]);
            ++i;
        }
        i = 0;
        n = functions.length;
        while (i < n) {
            this.addObject(functions[i], false);
            ++i;
        }
        this.mainFunctions = functions;
        this.setDefaultVariables(functions[0].getIndependentVariables());
    }

    public UserFunction[] getSupportFunctions() {
        ArrayList<FunctionEditor.FObject> temp = new ArrayList<FunctionEditor.FObject>();
        for (FunctionEditor.FObject next : this.objects) {
            if (this.isMainFunction(next)) continue;
            temp.add(next);
        }
        return temp.toArray(new UserFunction[0]);
    }

    @Override
    public String getName(FunctionEditor.FObject obj) {
        return obj == null ? null : ((UserFunction)obj).getName();
    }

    @Override
    public String getExpression(FunctionEditor.FObject obj) {
        return obj == null ? null : ((UserFunction)obj).getInputString();
    }

    @Override
    public String getDescription(FunctionEditor.FObject obj) {
        return obj == null ? null : ((UserFunction)obj).getDescription();
    }

    @Override
    public void setDescription(FunctionEditor.FObject obj, String desc) {
        if (obj != null) {
            if (desc != null && desc.trim().equals("")) {
                desc = null;
            }
            ((UserFunction)obj).setDescription(desc);
            super.setDescription(obj, desc);
        }
    }

    @Override
    public boolean isNameEditable(FunctionEditor.FObject obj) {
        return ((UserFunction)obj).isNameEditable();
    }

    @Override
    public boolean isExpressionEditable(FunctionEditor.FObject obj) {
        UserFunction f = (UserFunction)obj;
        return f.polynomial == null;
    }

    @Override
    public void evaluateAll() {
        this.setArrays();
        ParamEditor paramEditor = this.getParamEditor();
        if (!this.parametersValid && paramEditor != null) {
            paramEditor.evaluateAll();
        }
        int i = 0;
        while (i < this.evaluate.size()) {
            UserFunction f = (UserFunction)this.evaluate.get(i);
            if (!this.parametersValid && paramEditor != null) {
                f.setParameters(paramEditor.getNames(), paramEditor.getValues(), paramEditor.getDescriptions());
            }
            f.setExpression(f.getInputString(), f.getIndependentVariables());
            ++i;
        }
        this.parametersValid = true;
    }

    @Override
    public FunctionEditor.FObject addObject(FunctionEditor.FObject obj, int row, boolean postEdit, boolean firePropertyChange) {
        if ((obj = super.addObject(obj, row, postEdit, firePropertyChange)) != null) {
            this.firePropertyChange("function", null, obj);
        }
        return obj;
    }

    @Override
    public FunctionEditor.FObject removeObject(FunctionEditor.FObject obj, boolean postEdit) {
        if ((obj = super.removeObject(obj, postEdit)) != null) {
            this.firePropertyChange("function", obj, null);
        }
        return obj;
    }

    @Override
    public String getTooltip(FunctionEditor.FObject obj) {
        return obj == null ? null : ((UserFunction)obj).getDescription();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        UserFunction[] mainFunctions;
        String propName = e.getPropertyName();
        if (propName.equals("param_description")) {
            this.updateAllFunctions(this.paramEditor);
        } else if (propName.equals("edit") && (mainFunctions = this.getMainFunctions()).length > 0) {
            String newName = (String)e.getOldValue();
            String oldName = null;
            Object obj = e.getNewValue();
            UserFunction func = this.getMainFunctions()[0];
            if (func.polynomial != null && obj != null) {
                if (obj instanceof FunctionEditor.DefaultEdit) {
                    FunctionEditor.DefaultEdit edit = (FunctionEditor.DefaultEdit)obj;
                    if (edit.editType != 2) {
                        super.propertyChange(e);
                        return;
                    }
                    oldName = (String)edit.undoObj;
                } else if (obj instanceof String) {
                    oldName = (String)obj;
                }
                if (oldName != null) {
                    UserFunction f;
                    UserFunction[] userFunctionArray = this.getMainFunctions();
                    int n = userFunctionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        f = userFunctionArray[n2];
                        f.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
                        f.replaceParameterNameInExpression(oldName, newName);
                        ++n2;
                    }
                    userFunctionArray = this.getSupportFunctions();
                    n = userFunctionArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        f = userFunctionArray[n2];
                        f.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
                        f.replaceParameterNameInExpression(oldName, newName);
                        ++n2;
                    }
                }
            }
        }
        super.propertyChange(e);
    }

    void updateAllFunctions(ParamEditor paramEditor) {
        int i = 0;
        int n = this.objects.size();
        while (i < n) {
            ((UserFunction)this.objects.get(i)).setParameters(paramEditor.getNames(), paramEditor.getValues(), paramEditor.getDescriptions());
            ++i;
        }
    }

    @Override
    protected boolean isImportant(FunctionEditor.FObject obj) {
        int i = 0;
        while (i < this.mainFunctions.length) {
            if (this.mainFunctions[i] == obj) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void setReferences(FunctionEditor.FObject obj, BitSet refs) {
        UserFunction f = (UserFunction)obj;
        UserFunction[] references = new UserFunction[refs.cardinality()];
        int pt = 0;
        int i = refs.nextSetBit(0);
        while (i >= 0) {
            references[pt++] = (UserFunction)this.objects.get(i);
            i = refs.nextSetBit(i + 1);
        }
        f.setReferences(references);
    }

    protected void setDefaultVariables(String[] varNames) {
        this.defaultVariableNames = varNames;
    }

    @Override
    protected boolean isDisallowedName(FunctionEditor.FObject obj, String name) {
        boolean disallowed = super.isDisallowedName(obj, name);
        if (obj != null) {
            String var = ((UserFunction)obj).getIndependentVariable();
            boolean bl = disallowed = disallowed || var.equals(name);
        }
        if (disallowed) {
            return true;
        }
        if (obj != null && this.getName(obj).equals(name)) {
            return false;
        }
        if (this.functionPanel instanceof FitFunctionPanel) {
            FitFunctionPanel fitPanel = (FitFunctionPanel)this.functionPanel;
            if (fitPanel.functionTool != null) {
                String s = fitPanel.functionTool.getUniqueName(name);
                disallowed = !name.equals(s);
                for (DatasetCurveFitter next : fitPanel.functionTool.curveFitters) {
                    if (disallowed) {
                        return true;
                    }
                    disallowed = next.hasFit(name);
                }
            }
        }
        return disallowed;
    }

    @Override
    protected String getVariablesString(String separator) {
        int i;
        StringBuffer vars = new StringBuffer("");
        String[] paramNames = this.paramEditor.getNames();
        int i2 = 0;
        while (i2 < paramNames.length) {
            vars.append(" ");
            vars.append(paramNames[i2]);
            ++i2;
        }
        UserFunction f = (UserFunction)this.getSelectedObject();
        if (f != null) {
            String[] s = f.getIndependentVariables();
            i = 0;
            while (i < s.length) {
                vars.append(" ");
                vars.append(s[i]);
                ++i;
            }
        }
        ArrayList<String> namesToSkip = new ArrayList<String>();
        namesToSkip.add(this.getName(this.getSelectedObject()));
        i = 0;
        while (i < this.mainFunctions.length) {
            namesToSkip.add(this.getName(this.mainFunctions[i]));
            ++i;
        }
        i = 0;
        while (i < this.names.length) {
            if (!namesToSkip.contains(this.names[i])) {
                vars.append(" ");
                vars.append(this.names[i]);
            }
            ++i;
        }
        return this.getVariablesString(vars, separator);
    }

    @Override
    protected boolean isInvalidExpression(FunctionEditor.FObject obj) {
        return !((UserFunction)obj).isValid();
    }

    @Override
    protected FunctionEditor.FObject createObject(String name, String expression, FunctionEditor.FObject obj) {
        UserFunction f = (UserFunction)obj;
        if (f != null && f.getName().equals(name) && f.getInputString().equals(expression)) {
            return f;
        }
        if (f == null) {
            f = new UserFunction(name);
            f.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
            f.setExpression(expression, this.defaultVariableNames);
        } else if (!f.getName().equals(name)) {
            f.setNameEditable(true);
            f.setName(name);
        } else {
            f.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
            f.setExpression(expression, f.getIndependentVariables());
        }
        return f;
    }

    private boolean isMainFunction(FunctionEditor.FObject obj) {
        int i = this.mainFunctions.length;
        while (--i >= 0) {
            if (obj != this.mainFunctions[i]) continue;
            return true;
        }
        return false;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            UserFunctionEditor editor = (UserFunctionEditor)obj;
            UserFunction[] functions = editor.getMainFunctions();
            control.setValue("main_functions", functions);
            functions = editor.getSupportFunctions();
            if (functions.length > 0) {
                control.setValue("support_functions", functions);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new UserFunctionEditor();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            UserFunctionEditor editor = (UserFunctionEditor)obj;
            UserFunction[] functions = (UserFunction[])control.getObject("main_functions");
            editor.setMainFunctions(functions);
            int row = functions.length;
            functions = (UserFunction[])control.getObject("support_functions");
            if (functions != null) {
                int i = 0;
                while (i < functions.length) {
                    editor.addObject(functions[i], row + i, false, false);
                    ++i;
                }
            }
            return obj;
        }
    }
}

