/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.image.BufferedImage;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.media.core.VideoGrabber;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.VideoTool;

public class VideoCaptureTool
implements Tool,
VideoTool {
    private VideoCaptureTool mediaCap;

    public VideoCaptureTool() {
    }

    protected VideoCaptureTool(boolean ignored) {
    }

    @Override
    public boolean addFrame(BufferedImage image) {
        return this.getGrabber().addFrame(image);
    }

    @Override
    public void clear() {
        this.getGrabber().clear();
    }

    public void setRecording(boolean record) {
        this.getGrabber().setRecording(record);
    }

    @Override
    public boolean isRecording() {
        return this.getGrabber().isRecording();
    }

    @Override
    public void setVisible(boolean visible) {
        this.getGrabber().setVisible(visible);
    }

    public boolean isVisible() {
        return this.getGrabber().isVisible();
    }

    public boolean canCapture() {
        return this.getGrabber() != null;
    }

    public void setVideoType(VideoType type) {
        this.getGrabber().setVideoType(type);
    }

    public void setFrameRate(double fps) {
        this.getGrabber().setFrameRate(fps);
    }

    @Override
    public void send(Job job, Tool noReply) {
        BufferedImage image;
        if (job == null) {
            return;
        }
        String path = new XMLControlElement(job.getXML()).getString("imagepath");
        if (path != null && (image = ResourceLoader.getBufferedImage(path)) != null) {
            this.addFrame(image);
        }
    }

    public static VideoCaptureTool getTool() {
        return VideoGrabber.getTool();
    }

    private VideoCaptureTool getGrabber() {
        if (this.mediaCap == null) {
            this.mediaCap = new VideoGrabber();
        }
        return this.mediaCap;
    }
}

