/*
 * Decompiled with CFR 0.152.
 */
package swingjs.api.js;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import swingjs.api.js.DOMNode;
import swingjs.api.js.HTML5Canvas;

public interface HTML5Video
extends DOMNode {
    public static final String[] eventTypes = new String[]{"audioprocess", "canplay", "canplaythrough", "complete", "durationchange", "emptied", "ended", "error", "loadeddata", "loadedmetadata", "loadstart", "pause", "play", "playing", "progress", "ratechange", "seeked", "seeking", "stalled", "suspend", "timeupdate", "volumechange", "waiting"};

    public void addTextTrack() throws Throwable;

    public Object captureStream() throws Throwable;

    public String canPlayType(String var1) throws Throwable;

    public void fastSeek(double var1) throws Throwable;

    public void load() throws Throwable;

    public void mozCaptureStream() throws Throwable;

    public void mozCaptureStreamUntilEnded() throws Throwable;

    public void mozGetMetadata() throws Throwable;

    public void pause() throws Throwable;

    public int requestVideoFrameCallback(Object var1) throws Throwable;

    public DOMNode.Promise play() throws Throwable;

    public DOMNode.Promise seekToNextFrame() throws Throwable;

    public DOMNode.Promise setMediaKeys(Object var1) throws Throwable;

    public DOMNode.Promise setSinkId(String var1) throws Throwable;

    public static double getDuration(HTML5Video v) {
        return 0.0;
    }

    public static double setCurrentTime(HTML5Video v, double time) {
        return 0.0;
    }

    public static double getCurrentTime(HTML5Video v) {
        return 0.0;
    }

    public static String getErrorMessage(HTML5Video v) {
        return null;
    }

    public static Dimension getSize(HTML5Video v) {
        return new Dimension(0, 0);
    }

    public static BufferedImage getImage(HTML5Video v, int imageType) {
        Dimension d = HTML5Video.getSize(v);
        BufferedImage image = (BufferedImage)HTML5Video.getProperty(v, "_image");
        if (image == null || image.getWidth() != d.width || image.getHeight() != d.height) {
            if (d.width == 0 || d.height == 0) {
                return null;
            }
            image = new BufferedImage(d.width, d.height, imageType == Integer.MIN_VALUE ? -6 : imageType);
            HTML5Video.setProperty(v, "_image", image);
        }
        HTML5Canvas.setImageNode(v, image);
        return image;
    }

    public static void setProperty(HTML5Video jsvideo, String key, Object value) {
        if (!(value instanceof Number)) {
            boolean cfr_ignored_0 = value instanceof Boolean;
        }
    }

    public static Object getProperty(HTML5Video jsvideo, String key) {
        Object val = null;
        if (val == null) {
            return null;
        }
        switch ("") {
            case "number": {
                return 0.0;
            }
            case "boolean": {
                return false;
            }
        }
        return val;
    }

    public static Object[] addActionListener(final HTML5Video jsvideo, final ActionListener listener, String ... events) {
        if (events == null || events.length == 0) {
            events = eventTypes;
        }
        Function<Object, Void> f = new Function<Object, Void>(){

            @Override
            public Void apply(Object jsevent) {
                String name = "?";
                ActionEvent e = new ActionEvent(new Object[]{jsvideo, jsevent}, 12345, name, System.currentTimeMillis(), 0);
                listener.actionPerformed(e);
                return null;
            }
        };
        ArrayList<String> listeners = new ArrayList<String>();
        int i = 0;
        while (i < events.length) {
            Object func = null;
            listeners.add(events[i]);
            listeners.add((String)func);
            if (jsvideo != null) {
                jsvideo.addEventListener(events[i], func);
            }
            ++i;
        }
        return listeners.toArray(new Object[listeners.size()]);
    }

    public static void removeActionListener(HTML5Video jsvideo, Object[] listeners) {
        if (listeners == null) {
            int i = 0;
            while (i < eventTypes.length) {
                jsvideo.removeEventListener(eventTypes[i]);
                ++i;
            }
            return;
        }
        int i = 0;
        while (i < listeners.length) {
            String event = (String)listeners[i];
            Object listener = listeners[i + 1];
            jsvideo.removeEventListener(event, listener);
            i += 2;
        }
    }

    public static ImageIcon createIcon(Object source) {
        try {
            if (source instanceof URL) {
                return new ImageIcon((URL)source, "jsvideo");
            }
            if (source instanceof byte[]) {
                return new ImageIcon((byte[])source, "jsvideo");
            }
            if (source instanceof File) {
                return new ImageIcon(Files.readAllBytes(((File)source).toPath()));
            }
            return new ImageIcon(Files.readAllBytes(new File(source.toString()).toPath()));
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static JLabel createLabel(Object source) {
        ImageIcon icon = source instanceof ImageIcon ? (ImageIcon)source : HTML5Video.createIcon(source);
        return icon == null ? null : new JLabel(icon);
    }

    public static JDialog createDialog(Frame parent, Object source, int maxWidth, Function<HTML5Video, Void> whenReady) {
        return HTML5Video.createDialog(parent, source, maxWidth, true, whenReady);
    }

    public static JDialog createDialog(Frame parent, Object source, final int maxWidth, boolean addControls, final Function<HTML5Video, Void> whenReady) {
        final HTML5VideoDialog dialog = new HTML5VideoDialog(parent);
        Container p = dialog.getContentPane();
        p.setLayout(new BoxLayout(p, 1));
        final JLabel label = source instanceof JLabel ? (JLabel)source : HTML5Video.createLabel(source);
        label.setAlignmentX(0.5f);
        p.add(label);
        label.setVisible(false);
        JPanel q = dialog.controls = HTML5Video.getControls(label);
        p.add(q);
        q.setVisible(addControls);
        label.putClientProperty("controls", q);
        dialog.setModal(false);
        dialog.pack();
        dialog.setVisible(true);
        dialog.setVisible(false);
        final HTML5Video jsvideo = (HTML5Video)label.getClientProperty("jsvideo");
        Object[] j2sListener = HTML5Video.addActionListener(jsvideo, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (label.getClientProperty("jsvideo.size") != null) {
                    return;
                }
                Dimension dim = HTML5Video.getSize(jsvideo);
                while (dim.width > maxWidth) {
                    dim.width /= 2;
                    dim.height /= 2;
                }
                label.putClientProperty("jsvideo.size", dim);
                label.setPreferredSize(dim);
                label.setVisible(true);
                dialog.pack();
                if (whenReady != null) {
                    whenReady.apply(jsvideo);
                }
                HTML5Video.removeActionListener(jsvideo, (Object[])HTML5Video.getProperty(jsvideo, "j2sListener"));
            }
        }, "canplaythrough");
        HTML5Video.setProperty(jsvideo, "j2sListener", j2sListener);
        HTML5Video.setCurrentTime(jsvideo, 0.0);
        return dialog;
    }

    public static void cancelVideoFrameCallback(HTML5Video jsvideo) {
    }

    public static int requestVideoFrameCallback(HTML5Video jsvideo, Consumer<Object> callback) {
        Object f = null;
        if (f == null) {
            return 0;
        }
        int id = 0;
        try {
            id = jsvideo.requestVideoFrameCallback(f[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return id;
    }

    public static JPanel getControls(final JLabel label) {
        JPanel controls = new JPanel();
        controls.setAlignmentX(0.5f);
        JButton btn = new JButton("play");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ((HTML5Video)label.getClientProperty("jsvideo")).play();
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
        });
        controls.add(btn);
        btn = new JButton("pause");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ((HTML5Video)label.getClientProperty("jsvideo")).pause();
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
        });
        controls.add(btn);
        btn = new JButton("reset");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HTML5Video.setCurrentTime((HTML5Video)label.getClientProperty("jsvideo"), 0.0);
            }
        });
        controls.add(btn);
        return controls;
    }

    public static boolean nextFrame(HTML5Video jsvideo, double dt) {
        Boolean canSeek = (Boolean)HTML5Video.getProperty(jsvideo, "_canseek");
        if (canSeek == null) {
            canSeek = HTML5Video.getProperty(jsvideo, "seekToNextFrame") != null;
            HTML5Video.setProperty(jsvideo, "_canseek", canSeek);
        }
        try {
            if (canSeek.booleanValue()) {
                jsvideo.seekToNextFrame();
            } else {
                HTML5Video.setCurrentTime(jsvideo, HTML5Video.getCurrentTime(jsvideo) + dt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return canSeek;
    }

    public static int getFrameCount(HTML5Video jsvideo) {
        return (int)(HTML5Video.getDuration(jsvideo) / 0.033334);
    }

    public static void startVideo(HTML5Video jsevideo) {
        Object d = null;
    }

    public static class HTML5VideoDialog
    extends JDialog {
        public JPanel controls;

        public HTML5VideoDialog(Frame parent) {
            super(parent);
        }
    }
}

